#include <bits/stdc++.h>
using namespace std;

using ll = long long;

const ll mxN = 3010;
vector<ll> adj[mxN];
vector<bool> visited(mxN, false);

pair<ll, ll> bfs(ll u) {
    queue<pair<ll, ll>> q;
    q.push({u, 0});

    pair<ll, ll> maks = {u, 0};

    while(!q.empty()) {
        auto curr = q.front();
        q.pop();

        if (curr.second > maks.second) {
            maks = curr;
        }
        visited[curr.first] = true;

        for (int v : adj[curr.first]) {
            if(visited[v] == false) {
                q.push({v, curr.second + 1});
            }
        }
    }

    return maks;
}

void solve() {
    ll n, k;
    cin >> n >> k;

    for (int i = 0; i <= n; i++) {
        adj[i].clear();
        visited[i] = false;
    }

    for (int i = 0; i < n - 1; i++) {
        ll u, v; cin >> u >> v;
        adj[u].push_back(v);
        adj[v].push_back(u);
    }

    ll start = bfs(1).first;
//    cout << "START: " << start << "\n";

    for (int i = 1; i <= n; i++) visited[i] = false;

    auto kraj = bfs(start);
 //   cout << "END: " << kraj.first << "\n";

    ll diameter = kraj.second;
 //   cout << "DIJAMETER: " << diameter << "\n";

    ll edges_left = n - 1 - diameter;

    if (k == 0) cout << diameter << "\n";
    else if (k == 1) {
        cout << diameter + (edges_left > 0 ? 1 : 0) << "\n";
    }
}

int main()
{
    ios::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);

    int t; cin >> t;
    while(t--) {
   //     precomp();
        solve();
    }
    return 0;
}